/* Copyright (c) 2014 Synology Inc. All rights reserved. */

ace.define("ace/mode/powershell",["require","exports","module","ace/lib/oop","ace/mode/text","ace/tokenizer","ace/mode/powershell_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],function(c,e,b){var f=c("../lib/oop");var d=c("./text").Mode;var g=c("../tokenizer").Tokenizer;var a=c("./powershell_highlight_rules").PowershellHighlightRules;var i=c("./matching_brace_outdent").MatchingBraceOutdent;var j=c("./behaviour/cstyle").CstyleBehaviour;var k=c("./folding/cstyle").FoldMode;var h=function(){this.HighlightRules=a;this.$outdent=new i();this.$behaviour=new j();this.foldingRules=new k({start:"^\\s*(<#)",end:"^[#\\s]>\\s*$"})};f.inherits(h,d);(function(){this.lineCommentStart="#";this.blockComment={start:"<#",end:"#>"};this.getNextLineIndent=function(q,m,o){var l=this.$getIndent(m);var p=this.getTokenizer().getLineTokens(m,q);var r=p.tokens;if(r.length&&r[r.length-1].type=="comment"){return l}if(q=="start"){var n=m.match(/^.*[\{\(\[]\s*$/);if(n){l+=o}}return l};this.checkOutdent=function(n,l,m){return this.$outdent.checkOutdent(l,m)};this.autoOutdent=function(l,m,n){this.$outdent.autoOutdent(m,n)};this.createWorker=function(l){return null};this.$id="ace/mode/powershell"}).call(h.prototype);e.Mode=h});ace.define("ace/mode/powershell_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(c,b,d){var e=c("../lib/oop");var a=c("./text_highlight_rules").TextHighlightRules;var f=function(){var j=("function|if|else|elseif|switch|while|default|for|do|until|break|continue|foreach|return|filter|in|trap|throw|param|begin|process|end");var i=("Get-Alias|Import-Alias|New-Alias|Set-Alias|Get-AuthenticodeSignature|Set-AuthenticodeSignature|Set-Location|Get-ChildItem|Clear-Item|Get-Command|Measure-Command|Trace-Command|Add-Computer|Checkpoint-Computer|Remove-Computer|Restart-Computer|Restore-Computer|Stop-Computer|Reset-ComputerMachinePassword|Test-ComputerSecureChannel|Add-Content|Get-Content|Set-Content|Clear-Content|Get-Command|Invoke-Command|Enable-ComputerRestore|Disable-ComputerRestore|Get-ComputerRestorePoint|Test-Connection|ConvertFrom-CSV|ConvertTo-CSV|ConvertTo-Html|ConvertTo-Xml|ConvertFrom-SecureString|ConvertTo-SecureString|Copy-Item|Export-Counter|Get-Counter|Import-Counter|Get-Credential|Get-Culture|Get-ChildItem|Get-Date|Set-Date|Remove-Item|Compare-Object|Get-Event|Get-WinEvent|New-Event|Remove-Event|Unregister-Event|Wait-Event|Clear-EventLog|Get-Eventlog|Limit-EventLog|New-Eventlog|Remove-EventLog|Show-EventLog|Write-EventLog|Get-EventSubscriber|Register-EngineEvent|Register-ObjectEvent|Register-WmiEvent|Get-ExecutionPolicy|Set-ExecutionPolicy|Export-Alias|Export-Clixml|Export-Console|Export-Csv|ForEach-Object|Format-Custom|Format-List|Format-Table|Format-Wide|Export-FormatData|Get-FormatData|Get-Item|Get-ChildItem|Get-Help|Add-History|Clear-History|Get-History|Invoke-History|Get-Host|Read-Host|Write-Host|Get-HotFix|Import-Clixml|Import-Csv|Invoke-Command|Invoke-Expression|Get-Item|Invoke-Item|New-Item|Remove-Item|Set-Item|Clear-ItemProperty|Copy-ItemProperty|Get-ItemProperty|Move-ItemProperty|New-ItemProperty|Remove-ItemProperty|Rename-ItemProperty|Set-ItemProperty|Get-Job|Receive-Job|Remove-Job|Start-Job|Stop-Job|Wait-Job|Stop-Process|Update-List|Get-Location|Pop-Location|Push-Location|Set-Location|Send-MailMessage|Add-Member|Get-Member|Move-Item|Compare-Object|Group-Object|Measure-Object|New-Object|Select-Object|Sort-Object|Where-Object|Out-Default|Out-File|Out-GridView|Out-Host|Out-Null|Out-Printer|Out-String|Convert-Path|Join-Path|Resolve-Path|Split-Path|Test-Path|Get-Pfxcertificate|Pop-Location|Push-Location|Get-Process|Start-Process|Stop-Process|Wait-Process|Enable-PSBreakpoint|Disable-PSBreakpoint|Get-PSBreakpoint|Set-PSBreakpoint|Remove-PSBreakpoint|Get-PSDrive|New-PSDrive|Remove-PSDrive|Get-PSProvider|Set-PSdebug|Enter-PSSession|Exit-PSSession|Export-PSSession|Get-PSSession|Import-PSSession|New-PSSession|Remove-PSSession|Disable-PSSessionConfiguration|Enable-PSSessionConfiguration|Get-PSSessionConfiguration|Register-PSSessionConfiguration|Set-PSSessionConfiguration|Unregister-PSSessionConfiguration|New-PSSessionOption|Add-PsSnapIn|Get-PsSnapin|Remove-PSSnapin|Get-Random|Read-Host|Remove-Item|Rename-Item|Rename-ItemProperty|Select-Object|Select-XML|Send-MailMessage|Get-Service|New-Service|Restart-Service|Resume-Service|Set-Service|Start-Service|Stop-Service|Suspend-Service|Sort-Object|Start-Sleep|ConvertFrom-StringData|Select-String|Tee-Object|New-Timespan|Trace-Command|Get-Tracesource|Set-Tracesource|Start-Transaction|Complete-Transaction|Get-Transaction|Use-Transaction|Undo-Transaction|Start-Transcript|Stop-Transcript|Add-Type|Update-TypeData|Get-Uiculture|Get-Unique|Update-Formatdata|Update-Typedata|Clear-Variable|Get-Variable|New-Variable|Remove-Variable|Set-Variable|New-WebServiceProxy|Where-Object|Write-Debug|Write-Error|Write-Host|Write-Output|Write-Progress|Write-Verbose|Write-Warning|Set-WmiInstance|Invoke-WmiMethod|Get-WmiObject|Remove-WmiObject|Connect-WSMan|Disconnect-WSMan|Test-WSMan|Invoke-WSManAction|Disable-WSManCredSSP|Enable-WSManCredSSP|Get-WSManCredSSP|New-WSManInstance|Get-WSManInstance|Set-WSManInstance|Remove-WSManInstance|Set-WSManQuickConfig|New-WSManSessionOption");var h=this.createKeywordMapper({"support.function":i,keyword:j},"identifier");var g="eq|ne|ge|gt|lt|le|like|notlike|match|notmatch|replace|contains|notcontains|ieq|ine|ige|igt|ile|ilt|ilike|inotlike|imatch|inotmatch|ireplace|icontains|inotcontains|is|isnot|as|and|or|band|bor|not";this.$rules={start:[{token:"comment",regex:"#.*$"},{token:"comment.start",regex:"<#",next:"comment"},{token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},{token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"[$](?:[Tt]rue|[Ff]alse)\\b"},{token:"constant.language",regex:"[$][Nn]ull\\b"},{token:"variable.instance",regex:"[$][a-zA-Z][a-zA-Z0-9_]*\\b"},{token:h,regex:"[a-zA-Z_$][a-zA-Z0-9_$\\-]*\\b"},{token:"keyword.operator",regex:"\\-(?:"+g+")"},{token:"keyword.operator",regex:"&|\\*|\\+|\\-|\\=|\\+=|\\-="},{token:"lparen",regex:"[[({]"},{token:"rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],comment:[{token:"comment.end",regex:"#>",next:"start"},{token:"doc.comment.tag",regex:"^\\.\\w+"},{token:"comment",regex:"\\w+"},{token:"comment",regex:"."}]}};e.inherits(f,a);b.PowershellHighlightRules=f});ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(c,b,d){var e=c("../range").Range;var a=function(){};(function(){this.checkOutdent=function(f,g){if(!/^\s+$/.test(f)){return false}return/^\s*\}/.test(g)};this.autoOutdent=function(k,l){var g=k.getLine(l);var h=g.match(/^(\s*\})/);if(!h){return 0}var i=h[1].length;var j=k.findMatchingBracket({row:l,column:i});if(!j||j.row==l){return 0}var f=this.$getIndent(k.getLine(j.row));k.replace(new e(l,0,l,i-1),f)};this.$getIndent=function(f){return f.match(/^\s*/)[0]}}).call(a.prototype);b.MatchingBraceOutdent=a});ace.define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(e,h,c){var k=e("../../lib/oop");var f=e("../behaviour").Behaviour;var n=e("../../token_iterator").TokenIterator;var b=e("../../lib/lang");var j=["text","paren.rparen","punctuation.operator"];var d=["text","paren.rparen","punctuation.operator","comment"];var m=0;var a=-1;var o="";var g=0;var i=-1;var l="";var p="";var q=function(){q.isSaneInsertion=function(t,u){var v=t.getCursorPosition();var s=new n(u,v.row,v.column);if(!this.$matchTokenType(s.getCurrentToken()||"text",j)){var r=new n(u,v.row,v.column+1);if(!this.$matchTokenType(r.getCurrentToken()||"text",j)){return false}}s.stepForward();return s.getCurrentTokenRow()!==v.row||this.$matchTokenType(s.getCurrentToken()||"text",d)};q.$matchTokenType=function(s,r){return r.indexOf(s.type||s)>-1};q.recordAutoInsert=function(s,t,v){var u=s.getCursorPosition();var r=t.doc.getLine(u.row);if(!this.isAutoInsertedClosing(u,r,o[0])){m=0}a=u.row;o=v+r.substr(u.column);m++};q.recordMaybeInsert=function(s,t,v){var u=s.getCursorPosition();var r=t.doc.getLine(u.row);if(!this.isMaybeInsertedClosing(u,r)){g=0}i=u.row;l=r.substr(0,u.column)+v;p=r.substr(u.column);g++};q.isAutoInsertedClosing=function(t,r,s){return m>0&&t.row===a&&s===o[0]&&r.substr(t.column)===o};q.isMaybeInsertedClosing=function(s,r){return g>0&&s.row===i&&r.substr(s.column)===p&&r.substr(0,s.column)==l};q.popAutoInsertedClosing=function(){o=o.substr(1);m--};q.clearMaybeInsertedClosing=function(){g=0;i=-1};this.add("braces","insertion",function(s,v,y,B,D){var E=y.getCursorPosition();var F=B.doc.getLine(E.row);if(D=="{"){var C=y.getSelectionRange();var w=B.doc.getTextRange(C);if(w!==""&&w!=="{"&&y.getWrapBehavioursEnabled()){return{text:"{"+w+"}",selection:false}}else{if(q.isSaneInsertion(y,B)){if(/[\]\}\)]/.test(F[E.column])||y.inMultiSelectMode){q.recordAutoInsert(y,B,"}");return{text:"{}",selection:[1,1]}}else{q.recordMaybeInsert(y,B,"{");return{text:"{",selection:[1,1]}}}}}else{if(D=="}"){var z=F.substring(E.column,E.column+1);if(z=="}"){var r=B.$findOpeningBracket("}",{column:E.column+1,row:E.row});if(r!==null&&q.isAutoInsertedClosing(E,F,D)){q.popAutoInsertedClosing();return{text:"",selection:[1,1]}}}}else{if(D=="\n"||D=="\r\n"){var u="";if(q.isMaybeInsertedClosing(E,F)){u=b.stringRepeat("}",g);q.clearMaybeInsertedClosing()}var z=F.substring(E.column,E.column+1);if(z==="}"){var A=B.findMatchingBracket({row:E.row,column:E.column+1},"}");if(!A){return null}var x=this.$getIndent(B.getLine(A.row))}else{if(u){var x=this.$getIndent(F)}else{return}}var t=x+B.getTabString();return{text:"\n"+t+"\n"+x+u,selection:[1,t.length,1,t.length]}}else{q.clearMaybeInsertedClosing()}}}});this.add("braces","deletion",function(w,v,u,x,s){var t=x.doc.getTextRange(s);if(!s.isMultiLine()&&t=="{"){var r=x.doc.getLine(s.start.row);var y=r.substring(s.end.column,s.end.column+1);if(y=="}"){s.end.column++;return s}else{g--}}});this.add("parens","insertion",function(s,t,v,x,z){if(z=="("){var y=v.getSelectionRange();var u=x.doc.getTextRange(y);if(u!==""&&v.getWrapBehavioursEnabled()){return{text:"("+u+")",selection:false}}else{if(q.isSaneInsertion(v,x)){q.recordAutoInsert(v,x,")");return{text:"()",selection:[1,1]}}}}else{if(z==")"){var A=v.getCursorPosition();var B=x.doc.getLine(A.row);var w=B.substring(A.column,A.column+1);if(w==")"){var r=x.$findOpeningBracket(")",{column:A.column+1,row:A.row});if(r!==null&&q.isAutoInsertedClosing(A,B,z)){q.popAutoInsertedClosing();return{text:"",selection:[1,1]}}}}}});this.add("parens","deletion",function(w,v,u,x,s){var t=x.doc.getTextRange(s);if(!s.isMultiLine()&&t=="("){var r=x.doc.getLine(s.start.row);var y=r.substring(s.start.column+1,s.start.column+2);if(y==")"){s.end.column++;return s}}});this.add("brackets","insertion",function(s,t,v,x,z){if(z=="["){var y=v.getSelectionRange();var u=x.doc.getTextRange(y);if(u!==""&&v.getWrapBehavioursEnabled()){return{text:"["+u+"]",selection:false}}else{if(q.isSaneInsertion(v,x)){q.recordAutoInsert(v,x,"]");return{text:"[]",selection:[1,1]}}}}else{if(z=="]"){var A=v.getCursorPosition();var B=x.doc.getLine(A.row);var w=B.substring(A.column,A.column+1);if(w=="]"){var r=x.$findOpeningBracket("]",{column:A.column+1,row:A.row});if(r!==null&&q.isAutoInsertedClosing(A,B,z)){q.popAutoInsertedClosing();return{text:"",selection:[1,1]}}}}}});this.add("brackets","deletion",function(w,v,u,x,s){var t=x.doc.getTextRange(s);if(!s.isMultiLine()&&t=="["){var r=x.doc.getLine(s.start.row);var y=r.substring(s.start.column+1,s.start.column+2);if(y=="]"){s.end.column++;return s}}});this.add("string_dquotes","insertion",function(s,v,z,C,G){if(G=='"'||G=="'"){var r=G;var E=z.getSelectionRange();var w=C.doc.getTextRange(E);if(w!==""&&w!=="'"&&w!='"'&&z.getWrapBehavioursEnabled()){return{text:r+w+r,selection:false}}else{var F=z.getCursorPosition();var I=C.doc.getLine(F.row);var H=I.substring(F.column-1,F.column);if(H=="\\"){return null}var B=C.getTokens(E.start.row);var t=0,u;var y=-1;for(var D=0;D<B.length;D++){u=B[D];if(u.type=="string"){y=-1}else{if(y<0){y=u.value.indexOf(r)}}if((u.value.length+t)>E.start.column){break}t+=B[D].value.length}if(!u||(y<0&&u.type!=="comment"&&(u.type!=="string"||((E.start.column!==u.value.length+t-1)&&u.value.lastIndexOf(r)===u.value.length-1)))){if(!q.isSaneInsertion(z,C)){return}return{text:r+r,selection:[1,1]}}else{if(u&&u.type==="string"){var A=I.substring(F.column,F.column+1);if(A==r){return{text:"",selection:[1,1]}}}}}}});this.add("string_dquotes","deletion",function(w,v,u,x,s){var t=x.doc.getTextRange(s);if(!s.isMultiLine()&&(t=='"'||t=="'")){var r=x.doc.getLine(s.start.row);var y=r.substring(s.start.column+1,s.start.column+2);if(y==t){s.end.column++;return s}}})};k.inherits(q,f);h.CstyleBehaviour=q});ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(b,a,c){var d=b("../../lib/oop");var f=b("../../range").Range;var g=b("./fold_mode").FoldMode;var e=a.FoldMode=function(h){if(h){this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+h.start));this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+h.end))}};d.inherits(e,g);(function(){this.foldingStartMarker=/(\{|\[)[^\}\]]*$|^\s*(\/\*)/;this.foldingStopMarker=/^[^\[\{]*(\}|\])|^[\s\*]*(\*\/)/;this.getFoldWidgetRange=function(o,n,p,m){var h=o.getLine(p);var k=h.match(this.foldingStartMarker);if(k){var l=k.index;if(k[1]){return this.openingBracketBlock(o,k[1],p,l)}var j=o.getCommentFoldRange(p,l+k[0].length,1);if(j&&!j.isMultiLine()){if(m){j=this.getSectionRange(o,p)}else{if(n!="all"){j=null}}}return j}if(n==="markbegin"){return}var k=h.match(this.foldingStopMarker);if(k){var l=k.index+k[0].length;if(k[1]){return this.closingBracketBlock(o,k[1],p,l)}return o.getCommentFoldRange(p,l,-1)}};this.getSectionRange=function(m,p){var q=m.getLine(p);var i=q.search(/\S/);var o=p;var k=q.length;p=p+1;var l=p;var n=m.getLength();while(++p<n){q=m.getLine(p);var h=q.search(/\S/);if(h===-1){continue}if(i>h){break}var j=this.getFoldWidgetRange(m,"all",p);if(j){if(j.start.row<=o){break}else{if(j.isMultiLine()){p=j.end.row}else{if(i==h){break}}}}l=p}return new f(o,k,l,m.getLine(l).length)}}).call(e.prototype)});